﻿© Fluke Calibration. All Rights Reserved.                   MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub NI DC Power Constants
DATE:                  2011-10-19 08:01:21
AUTHOR:                Fluke
REVISION:              $Revision: 1.2 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       342
=============================================================================
#
# Text Src:
#   $RCSfile: sub_ni_dc_pwr_constants.txt,v $
#   $Date: 2011/10/19 15:01:56 $
#
# Procedure Author(s):
#       DAC
#
# Source:
#       National Instrunments DC Power Supplies and SMUs
#       ©National Instrunments 2011.  All Rights Reserved.
#       Title:    nidcpower.h
#       Purpose:  National Instrunments DC Power Supplies and SMUs Instr
#                 Driver declarations
#
# Compatibility:
#       MET/CAL 8.0
#
#  Subprocedures:
#       Sub IVI DC Power Constants
#
#  Required Files:
#       None
#
#  Additional Equipment Required:
#       None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  CALL         Sub IVI Constants
  1.002  CALL         Sub IVI DC Power Constants

#****************************************************************************
#*---------------------------- Attribute Defines ---------------------------*
#****************************************************************************

  1.003  MATH         AttrBase = @iviSpecPublicAttrBase

#*- IVI Inherent Instr Attributes -*

#*- User Options -*
  1.004  MATH         @niDCPwrAttrRngChk         = @iviAttrRngChk
  1.005  MATH         @niDCPwrAttrQueryInstrStat = @iviAttrQueryInstrStat
  1.006  MATH         @niDCPwrAttrCache          = @iviAttrCache
  1.007  MATH         @niDCPwrAttrSim            = @iviAttrSim
  1.008  MATH         @niDCPwrAttrRecCoercions   = @iviAttrRecCoercions
  1.009  MATH         @niDCPwrAttrInterchangeChk = @iviAttrInterchangeChk

#*- Instrument Capabilities -*
  1.010  MATH         @niDCPwrAttrChanCount = @iviAttrChanCount

#*- Driver Information
  1.011  MATH         Temp = @iviAttrSpecificDrvPrefix
  1.012  MATH         @niDCPwrAttrSpecificDrvPrefix    = Temp
  1.013  MATH         Temp = @iviAttrSupportedInstrModels
  1.014  MATH         @niDCPwrAttrSupportedInstrModels = Temp
  1.015  MATH         Temp = @iviAttrGroupCapabilities
  1.016  MATH         @niDCPwrAttrGroupCapabilities    = Temp
  1.017  MATH         Temp = @iviAttrInstrManufacturer
  1.018  MATH         @niDCPwrAttrInstrManufacturer    = Temp
  1.019  MATH         Temp = @iviAttrInstrModel
  1.020  MATH         @niDCPwrAttrInstrModel           = Temp
  1.021  MATH         Temp = @iviAttrInstrFirmwareRev
  1.022  MATH         @niDCPwrAttrInstrFirmwareRev     = Temp
  1.023  MATH         Temp = @iviAttrSpecificDrvRev
  1.024  MATH         @niDCPwrAttrSpecificDrvRev       = Temp
  1.025  MATH         Temp = @iviAttrSpecificDrvVendor
  1.026  MATH         @niDCPwrAttrSpecificDrvVendor    = Temp
  1.027  MATH         Temp = @iviAttrSpecificDrvDescr
  1.028  MATH         @niDCPwrAttrSpecificDrvDescr     = Temp
# 1.029  MATH         Temp = @iviAttrDrvClassSpecificMajorVer
# 1.030  MATH         @niDCPwrAttrDrvClassSpecificMajorVer = Temp
# 1.030  MATH         Temp = @iviAttrDrvClassSpecificMinorVer
# 1.032  MATH         @niDCPwrAttrDrvClassSpecificMinorVer = Temp

#*- Advanced Session Information -*
  1.029  MATH         @niDCPwrAttrLogicalName          = @iviAttrLogicalName
  1.030  MATH         Temp = @iviAttrIOResourceDescriptor
  1.031  MATH         @niDCPwrAttrIOResourceDescriptor = Temp
  1.032  MATH         @niDCPwrAttrDrvSetup             = @iviAttrDrvSetup

#*- Source Configuration -*
  1.033  MATH         @niDCPwrAttrSrcMode           = AttrBase + 54
  1.034  MATH         @niDCPwrAttrOutFunc           = AttrBase + 8
  1.035  MATH         @niDCPwrAttrOutEnabled        = @iviDCPwrAttrOutEnabled
  1.036  MATH         @niDCPwrAttrOutConnected      = AttrBase + 60
  1.037  MATH         @niDCPwrAttrOutResistance     = AttrBase + 61
  1.038  MATH         @niDCPwrAttrTransientResp     = AttrBase + 62
  1.039  MATH         @niDCPwrAttrVoltGainBW        = AttrBase + 67
  1.040  MATH         @niDCPwrAttrVoltCompFreq      = AttrBase + 68
  1.041  MATH         @niDCPwrAttrVoltPoleZeroRatio = AttrBase + 69
  1.042  MATH         @niDCPwrAttrCurrGainBW        = AttrBase + 70
  1.043  MATH         @niDCPwrAttrCurrCompFreq      = AttrBase + 71
  1.044  MATH         @niDCPwrAttrCurrPoleZeroRatio = AttrBase + 72

#*- DC Voltage Output Function Configuration -*
  1.045  MATH         @niDCPwrAttrVoltLvl          = @iviDCPwrAttrVoltLvl
  1.046  MATH         @niDCPwrAttrCurrLmt          = @iviDCPwrAttrCurrLmt
  1.047  MATH         @niDCPwrAttrVoltLvlSpec      = AttrBase + 5
  1.048  MATH         @niDCPwrAttrCurrLmtSpec      = AttrBase + 4
  1.049  MATH         Temp = @iviDCPwrAttrCurrLmtBehavior
  1.050  MATH         @niDCPwrAttrCurrLmtBehavior  = Temp
  1.051  MATH         @niDCPwrAttrVoltLvlAutorange = AttrBase + 15
  1.052  MATH         @niDCPwrAttrCurrLmtAutorange = AttrBase + 16

#*- DC Current Output Function Configuration -*
  1.053  MATH         @niDCPwrAttrCurrLvl          = AttrBase + 9
  1.054  MATH         @niDCPwrAttrVoltLmt          = AttrBase + 10
  1.055  MATH         @niDCPwrAttrCurrLvlSpec      = AttrBase + 11
  1.056  MATH         @niDCPwrAttrVoltLmtSpec      = AttrBase + 12
  1.057  MATH         @niDCPwrAttrCurrLvlAutorange = AttrBase + 17
  1.058  MATH         @niDCPwrAttrVoltLmtAutorange = AttrBase + 18

#*- Advance Source Configuration -*
  1.059  MATH         @niDCPwrAttrSrcDelay           = AttrBase + 51
  1.060  MATH         @niDCPwrAttrOverrangingEnabled = AttrBase + 7
  1.061  MATH         @niDCPwrAttrOutCapacitance     = AttrBase + 14
  1.062  MATH         @niDCPwrAttrSeqLoopCount       = AttrBase + 25

#*- Over Voltage Protection Configuration -*
  1.063  MATH         @niDCPwrAttrOVPEnabled = @iviDCPwrAttrOVPEnabled
  1.064  MATH         @niDCPwrAttrOVPLmt     = @iviDCPwrAttrOVPLmt

#*- Measurement Configuration -*
  1.065  MATH         @niDCPwrAttrSense              = AttrBase + 13
  1.066  MATH         @niDCPwrAttrAutoZero           = AttrBase + 55
  1.067  MATH         @niDCPwrAttrAperatureTime      = AttrBase + 58
  1.068  MATH         @niDCPwrAttrAperatureTimeUnits = AttrBase + 59
  1.069  MATH         @niDCPwrAttrPowerLineFreq      = AttrBase + 20
  1.070  MATH         @niDCPwrAttrSamplesToAvg       = AttrBase + 3
  1.071  MATH         @niDCPwrAttrFetchBacklog       = AttrBase + 56

#*- Advanced Measurement Configuration -*
  1.072  MATH         @niDCPwrAttrMeasWhen           = AttrBase + 57
  1.073  MATH         @niDCPwrAttrResetAvgBeforeMeas = AttrBase + 6
  1.074  MATH         @niDCPwrAttrMeasRecLen         = AttrBase + 63
  1.075  MATH         @niDCPwrAttrMeasRecLenIsFinite = Temp     + 64
  1.076  MATH         @niDCPwrAttrMeasRecDeltaTime   = AttrBase + 65
  1.077  MATH         @niDCPwrAttrDCNoiseRej         = AttrBase + 66
  1.078  MATH         @niDCPwrAttrSelfCalPersistence = AttrBase + 73

#*- Triggers Configuration -*
#*- Start Trigger -*
  1.079  MATH         @niDCPwrAttrStartTrigType                = AttrBase + 21
  1.080  MATH         @niDCPwrAttrDigEdgeStartTrigEdge         = AttrBase + 22
#       MATH         @niDCPwrAttrDigEdgeStartTrigInputTerminal = AttrBase + 23
#       MATH         @niDCPwrAttrExportedStartTrigOutTerminal  = AttrBase + 24

#*- Source Trigger -*
  1.081  MATH         @niDCPwrAttrSrcTrigType                 = AttrBase + 30
  1.082  MATH         @niDCPwrAttrDigEdgeSrcTrigEdge          = AttrBase + 31
#        MATH         @niDCPwrAttrDigEdgeSrcTrigInputTerminal = AttrBase + 32
#        MATH         @niDCPwrAttrExportedSrcTrigOutTerminal  = AttrBase + 33

#*- Measurement Trigger -*
  1.083  MATH         @niDCPwrAttrMeasTrigType                 = AttrBase + 34
  1.084  MATH         @niDCPwrAttrDigEdgeMeasTrigEdge          = AttrBase + 35
#        MATH         @niDCPwrAttrDigEdgeMeasTrigInputTerminal = AttrBase + 36
#        MATH         @niDCPwrAttrExportedMeasTrigOutTerminal  = AttrBase + 37

#*- Sequence Advance Trigger -*
  1.085  MATH         @niDCPwrAttrSeqAdvTrigType               = AttrBase + 26
#      MATH         @niDCPwrAttrDigEdgeSeqAdvTrigEdge          = AttrBase + 27
#      MATH         @niDCPwrAttrDigEdgeSeqAdvTrigInputTerminal = AttrBase + 28
#      MATH         @niDCPwrAttrExportedSeqAdvTrigOutTerminal  = AttrBase + 29

#*- Events Configuration -*
#*- Source Iteration Complete Event -*
#      MATH          @niDCPwrAttrSrcCompleteEventOutTerminal   = AttrBase + 43
#      MATH          @niDCPwrAttrSrcCompleteEventPulsePolarity = AttrBase + 41
#      MATH          @niDCPwrAttrSrcCompleteEventPulseWidth    = AttrBase + 42

#*- Measurement Complete Event -*
#     MATH          @niDCPwrAttrMeasCompleteEventOutTerminal   = AttrBase + 47
#     MATH          @niDCPwrAttrMeasCompleteEventDelay         = AttrBase + 46
#     MATH          @niDCPwrAttrMeasCompleteEventPulsePolarity = AttrBase + 44
#     MATH          @niDCPwrAttrMeasCompleteEventPulseWidth    = AttrBase + 45

#*- Sequence Iteration Complete Event -*
  1.086  MATH         Temp = AttrBase + 40
#        MATH         @niDCPwrAttrSeqIterationCompleteEventOutTerminal = Temp
  1.087  MATH         Temp = AttrBase + 38
#      MATH         @niDCPwrAttrSeqIterationCompleteEventPulsePolarity = Temp
  1.088  MATH         Temp = AttrBase + 39
#        MATH         @niDCPwrAttrSeqIterationCompleteEventPulseWidth  = Temp

#*- Sequence Engine Done Event -*
  1.089  MATH         Temp = AttrBase + 50
#        MATH         @niDCPwrAttrSeqEngineDoneEventOutTerminal   = Temp
  1.090  MATH         Temp = AttrBase + 48
#        MATH         @niDCPwrAttrSeqEngineDoneEventPulsePolarity = Temp
  1.091  MATH         Temp = AttrBase + 49
#        MATH         @niDCPwrAttrSeqEngineDoneEventPulseWidth    = Temp

#*- Advanced Instrument Configuration -*
  1.092  MATH         @niDCPwrAttrPowerSrc           = AttrBase + 0
  1.093  MATH         @niDCPwrAttrPowerSrcInUse      = AttrBase + 1
  1.094  MATH         @niDCPwrAttrAuxPwrSrcAvailable = AttrBase + 2

#****************************************************************************
#*------------------------ Attribute Value Defines -------------------------*
#****************************************************************************

  1.095  MATH         ValBase = 1000

#*- Defined values for behavior parameter of function -*
#*- ConfigureCurrLmt -*
#*- Defined values for attribute niDCPwrAttrCurrLmtBehavior
  1.096  MATH         @niDCPwrValCurrRegulate = @iviDCPwrValCurrRegulate
  1.097  MATH         @niDCPwrValCurrTrip     = @iviDCPwrValCurrTrip

#*- Defined values for rangeType parameter of function -*
#*- ConfigureOutSpec -*
  1.098  MATH         @niDCPwrValRngCurr  = @iviDCPwrValRngCurr
  1.099  MATH         @niDCPwrValRngcVolt = @iviDCPwrValRngVolt

#*- Defined values for outputState parameter of function -*
#*- QueryOutState -*
  1.100  MATH         @niDCPwrValOutConstVolt   = @iviDCPwrValOutConstVolt
  1.101  MATH         @niDCPwrValOutConstCurr   = @iviDCPwrValOutConstCurr
  1.102  MATH         @niDCPwrValOutOverVolt    = @iviDCPwrValOutOverVolt
  1.103  MATH         @niDCPwrValOutOverCurr    = @iviDCPwrValOutOverCurr
  1.104  MATH         @niDCPwrValOutUnregulated = @iviDCPwrValOutUnregulated

#*- Defined values for measurementType parameter of function -*
#*- Meas -*
  1.105  MATH         @niDCPwrValMeasCurr = @iviDCPwrValMeasCurr
  1.106  MATH         @niDCPwrValMeasVolt = @iviDCPwrValMeasVolt

#*- Defined values for action parameter of function -*
#*- CloseExtCal -*
  1.107  MATH         @niDCPwrValCancel = ValBase + 1
  1.108  MATH         @niDCPwrValCommit = ValBase + 2

#*- Defined values for attributes -*
#*- niDCPwrAttrPowerSrc -*
#*- niDCPwrAttrPowerSrcInUse -*
  1.109  MATH         @niDCPwrValInt  = ValBase + 3
  1.110  MATH         @niDCPwrValAux  = ValBase + 4
  1.111  MATH         @niDCPwrValAuto = ValBase + 5

#*- Defined values for outputFunction parameter for function -*
#*- ConfigureOutFunction -*
#*- Defined values for attribute niDCPwrAttrOutFunc -*
  1.112  MATH         @niDCPwrValDCV = ValBase + 6
  1.113  MATH         @niDCPwrValDCI = ValBase + 7

#*- Defined values for attribute niDCPwrAttrSense -*
  1.114  MATH         @niDCPwrValLocal  = ValBase + 8
  1.115  MATH         @niDCPwrValRemote = ValBase + 9

#*- Defined values for attribute niDCPwrAttrOutCapacitance -*
  1.116  MATH         @niDCPwrValLo = ValBase + 10
  1.117  MATH         @niDCPwrValHi = ValBase + 11

#*- Defined values for attributes niDCPwrAttr*Autorange -*
  1.118  MATH         @niDCPwrValOff = 0
  1.119  MATH         @niDCPwrValOn  = 1

#*- Defined values for attributes niDCPwrAttr*TrigType -*
  1.120  MATH         @niDCPwrValNone         = ValBase + 12
  1.121  MATH         @niDCPwrValDigEdge  = ValBase + 14
  1.122  MATH         @niDCPwrValSoftwareEdge = ValBase + 15

#*- Defined values for attributes niDCPwrAttrDigEdge*TrigEdge -*
  1.123  MATH         @niDCPwrValRising  = ValBase + 16
  1.124  MATH         @niDCPwrValFalling = ValBase + 17

#*- Defined values for attributes niDCPwrAttr*EventPulsePolarity -*
  1.125  MATH         @niDCPwrValActiveHi = ValBase + 18
  1.126  MATH         @niDCPwrValActiveLo = ValBase + 19

#*- Defined values for attribute niDCPwrAttrSrcMode -*
  1.127  MATH         @niDCPwrValSinglePoint = ValBase + 20
  1.128  MATH         @niDCPwrValSeq         = ValBase + 21

#*- Defined values for attribute niDCPwrAttrAutoZero -*
  1.129  MATH         @niDCPwrValOff  = 0
  1.130  MATH         @niDCPwrValOnce = ValBase + 24
  1.131  MATH         @niDCPwrValOn   = 1

#*- Defined values for attribute niDCPwrAttrMeasWhen  -*
  1.132  MATH         @niDCPwrValAutoAfterSrcComplete = ValBase + 25
  1.133  MATH         @niDCPwrValOnDemand             = ValBase + 26
  1.134  MATH         @niDCPwrValOnMeasTrig           = ValBase + 27

#*- Defined values for niDCPwrAttrPowerLineFreq -*
  1.135  MATH         @niDCPwrVal50Hz = 50.0
  1.136  MATH         @niDCPwrVal60Hz = 60.0

#*- Defined values for niDCPwrAttrAperatureTimeUnits -*
  1.137  MATH         @niDCPwrValSeconds         = ValBase + 28
  1.138  MATH         @niDCPwrValPowerLineCycles = ValBase + 29

#*- Defined values for Signal values -*
  1.139  MATH         @niDCPwrValSrcCompleteEvent          = ValBase + 30
  1.140  MATH         @niDCPwrValMeasCompleteEvent         = ValBase + 31
#        MATH         @niDCPwrValSeqIterationCompleteEvent = ValBase + 32
  1.141  MATH         @niDCPwrValSeqEngineDoneEvent        = ValBase + 33
  1.142  MATH         @niDCPwrValStartTrig                 = ValBase + 34
  1.143  MATH         @niDCPwrValSrcTrig                   = ValBase + 35
  1.144  MATH         @niDCPwrValMeasTrig                  = ValBase + 36
  1.145  MATH         @niDCPwrValSeqAdvTrig                = ValBase + 37

#*- Defined values for niDCPwrAttrTransientResp -*
  1.146  MATH         @niDCPwrValNormal = ValBase + 38
  1.147  MATH         @niDCPwrValFast   = ValBase + 39
  1.148  MATH         @niDCPwrValSlow   = ValBase + 41
  1.149  MATH         @niDCPwrValCustom = ValBase + 42

#*- Defined values for niDCPwrAttrDCNoiseRej -*
  1.150  MATH         @niDCPwrValDcNoiseRejNormal      = ValBase + 44
  1.151  MATH         @niDCPwrValDcNoiseRejSecondOrder = ValBase + 43

#*- Defined values for niDCPwrAttrSelfCalPersistence -*
  1.152  MATH         @niDCPwrValKeepInMemory  = ValBase + 45
  1.153  MATH         @niDCPwrValWriteToEEprom = ValBase + 46

  1.154  END